--
-- changeElementName.sql
--
DECLARE
  v_queryCtx  DBMS_XMLQuery.ctxType;
  v_result    CLOB;
BEGIN
  -- set the query context
  v_queryCtx := 
    DBMS_XMLQuery.newContext('SELECT * FROM employees WHERE rownum < 21');
  -- change <ROW> to <EMP>
  DBMS_XMLQuery.setRowTag(v_queryCtx,'EMP');       -- sets the row tag name
  -- change <ROWSET> to <EMPSET>
  DBMS_XMLQuery.setRowSetTag(v_queryCtx,'EMPSET'); -- sets rowset tag name

  v_result := DBMS_XMLQuery.getXML(v_queryCtx);      -- get the result

  printClobOut(v_result);  -- print the result
  DBMS_XMLQuery.closeContext(v_queryCtx);          -- close the query handle
END;
/
